const JavaScriptObfuscator = require('javascript-obfuscator');
const fs = require('fs');
const path = require('path');

// Şifrelenecek dosyalar
const filesToProtect = [
    'index.js',
    'license.js',
    'index_lisans.js'
];

// Obfuscation Ayarları (Yüksek Güvenlik)
const obfuscationOptions = {
    compact: true,
    controlFlowFlattening: true,
    controlFlowFlatteningThreshold: 0.75,
    deadCodeInjection: true,
    deadCodeInjectionThreshold: 0.4,
    debugProtection: true,
    debugProtectionInterval: 4000,
    disableConsoleOutput: true,
    identifierNamesGenerator: 'hexadecimal',
    log: false,
    numbersToExpressions: true,
    renameGlobals: false,
    selfDefending: true,
    simplify: true,
    splitStrings: true,
    splitStringsChunkLength: 10,
    stringArray: true,
    stringArrayCallsTransform: true,
    stringArrayEncoding: ['rc4'],
    stringArrayIndexShift: true,
    stringArrayRotate: true,
    stringArrayShuffle: true,
    stringArrayWrappersCount: 1,
    stringArrayWrappersChainedCalls: true,
    stringArrayWrappersParametersMaxCount: 2,
    stringArrayWrappersType: 'variable',
    stringArrayThreshold: 0.75,
    transformObjectKeys: true,
    unicodeEscapeSequence: false
};

console.log("🔐 Starting Code Protection Process...");

// Backup klasörü oluştur
const backupDir = path.join(__dirname, 'src_backup');
if (!fs.existsSync(backupDir)) {
    fs.mkdirSync(backupDir);
}

filesToProtect.forEach(file => {
    const filePath = path.join(__dirname, file);

    if (fs.existsSync(filePath)) {
        console.log(`Processing: ${file}...`);

        // 1. Orijinal dosyayı oku
        const code = fs.readFileSync(filePath, "utf8");

        // 2. Yedek al (önemli!)
        fs.writeFileSync(path.join(backupDir, file), code);
        console.log(`- Backup created at src_backup/${file}`);

        // 3. Şifrele
        const obfuscationResult = JavaScriptObfuscator.obfuscate(code, obfuscationOptions);
        const protectedCode = obfuscationResult.getObfuscatedCode();

        // 4. Şifreli haliyle kaydet
        fs.writeFileSync(filePath, protectedCode);
        console.log(`- Protected version saved to ${file} ✅`);
    } else {
        console.warn(`! File not found: ${file}`);
    }
});

console.log("\n✨ All files protected! Original source codes are in 'src_backup' folder.");
console.log("⚠️  WARNING: Do not edit the .js files in the root directly anymore. Edit files in 'src_backup' and run this script again.");
